### 概览

MQTT（Message Queuing Telemetry Transport）是一种轻量级、基于发布-订阅模式的消息传输协议，适用于资源受限的设备和低带宽、高延迟或不稳定的网络环境。它在物联网应用中广受欢迎，能够实现传感器、执行器和其它设备之间的高效通信。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e23f04279.png)


* ***QoS***

  * QoS（Quality of Service）指消息传输的服务质量。分别可在消息发送端和消息消费端设置。

    * 发送端的QoS设置：影响发送端发送消息到服务器消息队列 MQTT 版的传输质量。

    * 消费端的QoS设置：影响服务器消息队列 MQTT 版服务端投递消息到消费端的传输质量。

  * QoS包括以下级别：

    * QoS0：代表最多分发一次。

    * QoS1：代表至少达到一次。

    * QoS2：代表仅分发一次。


本手册使用一台WINDOWS电脑作为MQTT Broker，一台个人电脑和一台工智机作为客户端，实现相互订阅和发布信息。如下图所示：


![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e24c96f46.png)


下表概述了本手册各个产品组件

| **产品组件**                         | **描述说明**              |
| -------------------------------- | --------------------- |
| iotmqtt\_0.0.2\_amd64.deb        | 工智机MQTT组件             |
| MQTT\_Client.projectarchive      | PLC工程存档               |
| sf4202\_iotmqtt\_1.0.2.0.library | PLC工程库文件              |
| emqx-5.3.2-windows-amd64.zip     | EMQX压缩文件（MQTT Broker） |
| MQTTX-Setup-1.11.0-x64.exe       | MQTT客户端安装程序           |

---
### 安装卸载

**安装要求**

* 中科时代出厂的工智机的自带系统；

* SX、SP全系工智机

* 工智机可以访问互联网；

**安装过程**

**1、安装EMQX（MQTT Broker）**

将官网下载的emqx-5.3.2-windows-amd64.zip进行解压缩，自行解压到相应的文件夹中。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e28bae498.png)

打开文件夹目录bin，在文件夹位置处输入“cmd”，回车。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e2953f2bd.png)

在命令行中输入——emqx start——回车
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e29ea554b.png)

启动完成
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e2a7751c7.png)

EMQX端口号：

| **端口号** | **说明**               |
| ------- | -------------------- |
| 1833    | TCP 端口               |
| 8883    | WebSocket 端口         |
| 8884    | WebSocket Secure 端口  |
| 8883    | SSL/TLS 端口           |
| 18083   | Broker的Dashboard访问端口 |


可以通过18083端口访问MQTT Broker可视化界面

本机访问：127.0.0.1:18083/

外部访问：192.168.110.147:18083/   &#x20;

(192.168.110.147是本例MQTT Broker的IP地址)
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800ed2b8a263.png)


用户名：admin

密码：public


首次登录会提示修改密码，也可以选择跳过。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e2bdc39bb.png)

Dashboard界面，可以进行Broker的设置以及查看客户端连接情况、消息订阅等等。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e2c643b73.png)


**WINDOWS个人电脑安装MQTTX**

本手册使用MQTTX作为客户端进行消息的发布和订阅。

打开从官方网站下载的MQTTX-Setup-x64.exe程序，选择安装选项—下一步。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e2d93d2ac.png)

选择安装目录—安装
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e2e03a0a4.png)

安装完成后，点击MQTTX图标——新建连接。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e2e8092be.png)


填写客户端

| **参数**        | **说明**        | **设定例**         |
| ------------- | ------------- | --------------- |
| **Name**      | 客户名字          | user1           |
| **Host**      | 主机IP地址        | 192.168.110.147 |
| **Port**      | 端口            | 1883            |
| **Client ID** | 客户端ID，必须是唯一标识 | mqtt\_user1     |

![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e2f843ef1.png)

点击右上角“Connect”进行连接，连接成功后：

![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e30379cb9.png)

在MQTT Broker界面可以看到连接数变为1.
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e31157f86.png)

点击客户端，显示客户端ID、连接情况、IP地址等信息：
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e31885aaa.png)

回到MQTTX客户端，发布消息，格式为Plaintext，主题为a，负载内容为a=0
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e31f6edc5.png)


Broker界面可以看到消息流入数为1，由于没有客户端订阅主题a，所有消息被丢弃。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e328263d4.png)


**3、工智机安装iotmqtt\_0.0.2\_amd64.deb组件**

参考**附录一**，使用Windows cmd输入命令将iotmqtt\_0.0.2\_amd64.deb文件安装至工智机中。

```shell
scp -P 2224 iotmqtt_0.0.2_amd64.deb sinsegye@192.168.110.137:~
ssh -p 2224 sinsegye@192.168.110.137
sudo dpkg -i iotmqtt_0.0.2_amd64.deb
sudo nano /usr/local/etc/SinsegyeRTE/SinsegyeRTE.cfg
修改ComponentManager
sudo reboot
```
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e3e1ca717.png)

**4、工智机安装iotmqtt.library库文件**

打开MetaFacture程序，选择“工具”——“库存储”

![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e40514628.png)

选择“安装”
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e41048acc.png)

选择从中科时代官方下载的**iotmqtt.library**库文件
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e41c7182b.png)


安装完成
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e4285a7e3.png)


**更新安装**

参考上一章《**安装过程**》，将新的deb文件和库文件覆盖安装即可更新。

**卸载过程**

**1、停止EMQX（MQTT Broker）**

打开EMQX文件夹——打开目录bin，在文件夹位置处输入“cmd”，回车。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e44960400.png)

在命令行中输入——emqx stop——回车
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e453069a1.png)

等待片刻后，停止EMQX服务。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e45e710f0.png)

**2、使用控制面板卸载MQTTX**
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e468ace9f.png)

![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e473945e3.png)

![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e47c25ea0.png)

**3、卸载工智机iotmqtt\_0.0.2\_amd64.deb组件**

1 使用dpkg -r命令进行卸载

```shell
sudo dpkg -r iotmqtt
```


3.2 修改RTE的配置文件，ComponentManger模块下去掉iotmqtt

```shell
sudo nano /usr/local/etc/SinsegyeRTE/SinsegyeRTE.cfg
```
删除Component.8=iotmqtt
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e526db7ca.png)


3.3 重启工智机

```shell
sudo reboot
```
**4、卸载MetaFacture中的库文件iotmqtt.library**

4.1 打开软件，点击“工具”—“库存储”
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e556e907b.png)

4.2 在“杂项”中找到需要卸载的库文件，选中后点击“卸载”
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e55ed7c83.png)


---
### 技术说明

**快速启动**

 **（一）本例软、硬件配置**

| **硬件：**|**软件：**  |
| - | - |
| 1.工智机SX20|1.服务端软件emqx-5.3.2
2.服务端电脑（WINDOWS）|客户端软件MQTTX 1.11.0
3.个人电脑（WINDOWS）|工智机组件iotmqtt_0.0.2_amd64.deb |
| |4.PLC库文件iotmqtt.library |
||5.PLC存档工程MQTT_Client.projectarchive
||6.中科时代MetaFacture V1.0.6.3

**（二）本例实验操作步骤**

**1.实验要求**

a.MQTT Broker成功运行EMQX；

b.个人电脑安装MQTTX，并与Broker成功连接，并订阅主题“zksd”；

c.工智机成功安装iotmqtt\_0.0.2\_amd64.deb组件

d.MetaFacture成功安装库文件iotmqtt.library


**2.实验原理图**
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e67166aed.png)

**3.实验步骤**

3.1 使用MetaFacture打开PLC存档工程“MQTT\_Client.projectarchive”。登录设备，下载PLC程序并启动运行。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e7714092c.png)

3.2 点击PLC程序“Connect”，配置Broker端的IP地址和端口，将变量bConnect置TRUE，工智机连接Broker。

可以在Broker Dashboard界面查看到连接的客户端情况。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e77ed354d.png)
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e78b263af.png)

3.3 点击PLC程序“Publish”，将变量bPublish置TRUE。在MQTTX客户端可以收到订阅消息。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e79667be3.png)
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e79fd8560.png)


3.4 点击PLC程序“Subscribe”，将变量bSubscribe置TRUE。订阅三个主题“x”“y”“z”。在MQTTX客户端中发送三个主题消息。PLC程序变量topic和playload可以收到主题和内容。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e7ab7843f.png)

![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e7b48a81c.png)

发送主题消息：
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e7bfd9c61.png)

![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e7c9b40dc.png)

![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e7d436b1f.png)

3.5 点击PLC程序“Unbscribe”，将变量bUnSubscribe置TRUE。取消订阅“x”“y”“z”。在Broker Dashboard界面—订阅管理可以看到已经取消订阅。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e80533fec.png)
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e80eb9336.png)

3.6 MQTTX客户端断开重连后，可以收到标记为Retained的保留消息。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e81ef4104.png)

3.7 工智机手动拔除网线，约5秒后，MQTTX客户端收到一条“offine”的遗嘱消息。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e8299891c.png)

---
### 示例

#### **创建工程**

打开中科时代MetaFacture V1.0.6.3,选择“文件”——“新建工程”
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e84236e28.png)

选择标准工程——命名为MQTT\_Client——点击“确定”
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e84de004f.png)

选择Sinsegye工智机以及编程语言（本例为ST语言）
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e8568318d.png)

选择“库管理器”——“添加库”——在杂项中选择“iotmqtt”——点击“确定”。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e8617030b.png)

PLC工程中完成库文件添加。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e86d17bf4.png)

#### **建立MQTT客户端**

鼠标右键“Application”——“添加对象”——“全局变量列表”
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e88182ea5.png)

命名全局变量列表名称
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e88a82c8d.png)

添加如下变量：
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e89a50a83.png)

| **实例名称**         | **功能块名称**                   | **说明**     |
| ---------------- | --------------------------- | ---------- |
| **Client**       | TMP.FB\_IotMqttClient       | 实例化MQTT客户端 |
| **MessageQueue** | TMP.FB\_IotMqttMessageQueue | 存放订阅的消息队列  |
| **Message**      | TMP.FB\_IotMqttMessage      | 取出的单条订阅消息  |


鼠标右键“Application”——“添加对象”——“POU”
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e8af7863e.png)

将程序命名为“Connect”，选择ST语言后，点击“添加”
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e8ba4f1bd.png)

在Connect的PLC中，鼠标右键空白处，选择“输入助手”
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e8c45dc29.png)

点击“实例调用”——找到工程Application的GVL中的Client，点击“确定”
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e8d14b1ee.png)
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e8e1b19cc.png)

添加参数Client ID、Host IP、Host Port、心跳时间、消息队列指针。

关于功能块的参数说明，详见**功能介绍**章节。

| **参数**             | **说明**         | **设定例**           |
| ------------------ | -------------- | ----------------- |
| **sClientId**      | 客户端ID          | ‘Sinsegye’        |
| **sHostName**      | 连接IP地址         | ‘192.168.110.147’ |
| **nHostPort**      | 连接端口号          | 1883              |
| **nKeepAlive**     | 心跳报文发送间隔时间，单位s | 60                |
| **ipMessageQueue** | 指向消息队列         | ADR(MessageQueue) |

![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e8ede9d75.png)



#### **连接MQTT Broker**

声明BOOL型连接变量bConnect
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e8fa7fbe5.png)

使用Client.Execute()方法进行连接，将变量bConnect作为实参传入方法。

关于方法参数说明详见**功能介绍**章节。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e90fe34e1.png)

点击PLC\_PRG程序，调用Connect程序。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e91ac992e.png)

登录工智机，将PLC下载至工智机中。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e9243a163.png)

启动PLC
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e93105b8a.png)

将bConnect变量置为TRUE,Ctrl+F7写入变量，客户端与MQTT Broker进行连接。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e93f41ff2.png)


查看Broker的Dashboard的客户端界面，可以看到mqttx\_user1是个人电脑使用MQTTX创建的客户端，而Sinsegye是工智机创建的客户端。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e94b995e8.png)



#### **发布消息**

新建一个POU程序，命名为Publish。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e95ccabe9.png)


声明变量
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e98d7d0e8.png)

添加PLC程序，其中bPublish\_Trig功能块作用是取bPubish变量的上升沿。

使用Client.Publish()方法发布消息，

发布主题为zksd，内容为This is Sinsegye的消息。

关于方法参数说明详见**功能介绍**章节
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e99e4a2f6.png)

在个人电脑侧MQTTX客户端，订阅zksd主题
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e9aa4e288.png)

点击PLC\_PRG程序，调用Publisht程序。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e9b4251c8.png)

登录工智机，将PLC下载至工智机中，启动PLC。

1.先将bConnect变量置为TRUE,Ctrl+F7写入变量，客户端与MQTT Broker进行连接。

2.再将bPublish变量置为TRUE,Ctrl+F7写入变量，发布消息。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e9c3067b7.png)

MQTTX客户端收到主题为zksd的消息
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e9d29d044.png)

#### **订阅消息**

新建一个POU程序，命名为Subscribe。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e9dbafbe4.png)

声明变量
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e9e708904.png)

添加PLC程序。使用Client.Subscribe()方法订阅消息。

本例订阅了三个主题，分别为‘x’、‘y’和‘z’

关于方法参数说明详见**功能介绍**章节。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e9f394bcb.png)

当消息发送过来后，存储再消息队列中，需要取出消息，添加消息取出的PLC代码：
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800e9fe1bf98.png)

在PLC\_PRG中调用Subscribe程序
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800ea069c9d0.png)

登录工智机，将PLC下载至工智机中，启动PLC。

1.先将bConnect变量置为TRUE,Ctrl+F7写入变量，客户端与MQTT Broker进行连接。

2.再将bSubscribe变量置为TRUE,Ctrl+F7写入变量，订阅三个主题的消息。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800ea13c9721.png)

订阅成功
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800ea1f73635.png)

可以在Broker的 订阅管理中，看到订阅成功
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800ea7b8e170.png)


在个人电脑MQTTX客户端中发布消息进行测试

| **发布消息序列** | **主题** | **内容** |
| ---------- | ------ | ------ |
| **1**      | x      | x=1    |
| **2**      | y      | y=2    |
| **3**      | z      | z=3    |
| **4**      | x      | x=4    |

![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800ea2c734e1.png)

在PLC程序中，变量topic记录了历史消息的主题
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800ea35751c6.png)

变量playload记录了历史消息的内容
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800ea3e775d1.png)

#### **取消订阅**

新建一个POU程序，命名为UnSubscribe，声明如下变量。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800ea498d6c2.png)

添加PLC程序。使用Client.UnSubscribe()方法取消订阅。传入String类型的主题字符，取消订阅‘x’、‘y’和‘z’主题消息

关于方法参数说明详见**功能介绍**章节。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800ea52e7b31.png)

在PLC\_PRG中调用UnSubscribe程序
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800ea5dc9258.png)

登录工智机，将PLC下载至工智机中，启动PLC。

1.先将bConnect变量置为TRUE,Ctrl+F7写入变量，客户端与MQTT Broker进行连接。;查看Broker的订阅管理，Sinsegye订阅了三个主题
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800ea72a7b0f.png)

2.再将bUnsubscribe变量置为TRUE,Ctrl+F7写入变量，取消订阅三个主题的消息。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800ea85bd004.png)

取消成功
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800ea8e1e446.png)

查看Broker的订阅管理，点击“刷新”，Sinsegye取消订阅。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800ea9711366.png)

#### **保留消息**

MQTT保留消息(Retained Messages)是一种在MQTT中发布持久化消息的方式。当客户端发布一条保留消息，它会在MQTT服务器上保存这条消息。当新的订阅者连接到服务器时，服务器会将这条保留消息发送给新的订阅者。一个主题只会存储一条保留消息，新的保留消息会替换旧的保留消息。

设置使用Client.Publish()方法的bRetain参数为TRUE，发布的消息即为保留消息.
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800ea9f2667a.png)

登录工智机，将PLC下载至工智机中，启动PLC。

1.先将bConnect变量置为TRUE,Ctrl+F7写入变量，客户端与MQTT Broker连接。

2.再将bPublish变量置为TRUE,Ctrl+F7写入变量，发布保留消息。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800eaa8c8c54.png)

如果发送保留消息时，订阅zksd的MQTTX客户端在线，则正常收到消息。

如果发送保留消息时，订阅zksd的MQTTX客户端离线，则当MQTTX上线后会收到标记为Retained的保留消息。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800eab1613dc.png)

#### **遗嘱消息**

遗嘱消息是一种特殊的消息，用于客户端异常断开连接时，向其他订阅者通知其离线状态的消息。

在Connect程序中，声明遗嘱消息。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800eabab8fb1.png)

设定遗嘱消息结构体成员，并将结构体传入Client客户端的stWill参数。同时，为了方便演示异常断开，将心跳报文发送时间设为5s

| **遗嘱结构体成员**      | **类型**  | **设定例**                             | **说明**      |
| ---------------- | ------- | ----------------------------------- | ----------- |
| **sTopic**       | String  | ‘zksd’                              | 遗嘱消息主题为zksd |
| **pPayload**     | Pointer | ADR(WillingPayload)                 | 遗嘱消息内容指针    |
| **nPayloadSize** | UDINT   | INT\_TO\_UDINT(Len(WillingPayload)) | 遗嘱消息数据长度    |
| **eQoS**         | UINT    | 2                                   | eQoS消息质量等级2 |
| **bRetain**      | Bool    | FALSE                               | 不是保留消息      |

![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800eac4a7f19.png)

登录工智机，将PLC下载至工智机中，启动PLC。

1.先将bConnect变量置为TRUE,Ctrl+F7写入变量，客户端与MQTT Broker连接。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800eacc4b037.png)

2.手动断开工智机网络连接线。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800ead45338a.png)

3.在MQTTX客户端，收到遗嘱消息。
![](https://resource.helplook.net/docker_production/3648ne/article/kSJYenpn/6800eade009e7.png)